﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Microsoft.Practices.Prism.Commands;
using Microsoft.Practices.Prism.Regions;
using Microsoft.Practices.ServiceLocation;

namespace ModuleA
{
	class ButtonViewAViewModel
	{
		private readonly IRegionManager regionManager;
		public DelegateCommand SwitchViewCommand { get; set; }

		public ButtonViewAViewModel()
		{
			regionManager = ServiceLocator.Current.GetInstance<IRegionManager>();
			SwitchViewCommand = new DelegateCommand(SwitchView);
		}

		private void SwitchView()
		{
			regionManager.RequestNavigate("MainRegion", new Uri("ModuleAView", UriKind.Relative));
		}
	}
}
